set more off
cap log close
clear
set virtual on

log using summary_stats_and_figures, replace

*** This program describes the full set of variables used, and computes some basic summary statistics and descriptive figures for the paper

tempfile basedat 

use analytic_file

save "`basedat'", replace


** SUMMARY STATISTICS **

* Demographics
* Create sum of co-morbid conditions
egen num_comorbid=rowtotal(dz*)
*Private
tabstat age male income num_comorbid dz_14 if mcbs==0, c(s) s(mean sd n)  format(%9.2fc)
*Public
tabstat age male income num_comorbid dz_14 if mcbs==1, c(s) s(mean sd  n)  format(%9.2fc)

* Utilization
*Private
tabstat no_hosp days_hosp outpat_vis rx_30de if mcbs==0, c(s) s(mean sd p25 p50 p75)  format(%9.2fc)
*Public
tabstat no_hosp days_hosp outpat_vis rx_30de if mcbs==1, c(s) s(mean sd p25 p50 p75)  format(%9.2fc)

* Spending
*Convert dollar values to thousands
foreach i in tot_med inpat_exp outpat_exp rx_exp {
replace `i'=`i'/1000
}
*Private
tabstat tot_med inpat_exp outpat_exp rx_exp  if mcbs==0, c(s) s(mean sd p25 p50 p75)  format(%9.2fc)
*Public
tabstat tot_med inpat_exp outpat_exp rx_exp if mcbs==1, c(s) s(mean sd p25 p50 p75)  format(%9.2fc)


** CREATE KERNEL PLOTS AND SCATTER PLOTS - SAMPLE MEANS **


* Step 1: Collapse Data

collapse (mean) tot_med inpat_exp outpat_exp rx_exp no_hosp days_hosp outpat_vis rx_30de, by(msa mcbs)

reshape wide tot_med inpat_exp outpat_exp rx_exp no_hosp days_hosp outpat_vis rx_30de, i(msa) j(mcbs)


* De-mean the data
*Private
for ZZ in any tot_med0 inpat_exp0 outpat_exp0 rx_exp0 no_hosp0 days_hosp0 outpat_vis0 rx_30de0: qui sum ZZ \ replace ZZ=ZZ-r(mean) 
*Public
for ZZ in any tot_med1 inpat_exp1 outpat_exp1 rx_exp1 no_hosp1 days_hosp1 outpat_vis1 rx_30de1: qui sum ZZ \ replace ZZ=ZZ-r(mean) 

*Generate the data for the 45 degree line passing through the minimum point
for ZZ in any tot_med inpat_exp outpat_exp rx_exp no_hosp days_hosp outpat_vis rx_30de:  qui reg ZZ0 ZZ1 \ predict ZZhat \ sum ZZ1 \ scalar ZZmin=r(min) \ sum ZZhat if ZZ1==ZZmin \ gen ZZ_pub45=ZZ1-ZZmin +r(mean) 

* Estimate the slopes and standard errors
reg days_hosp0 days_hosp1, robust
reg outpat_vis0 outpat_vis1, robust
reg no_hosp0 no_hosp1, robust
reg rx_30de0 rx_30de1, robust


** DENSITY PLOTS **
* Use kdensity command
* Overlay density of public and private
* Use STATA defaults

* Density of inpatient spending
twoway (kdensity inpat_exp0  , range(-4 4)) (kdensity inpat_exp1  , range(-4 4) lpattern(dash)), ytitle(Density) ylabel(, angle(horizontal) format(%9.1fc)) xtitle(Deviation from Sample Mean) xtitle() xscale(titlegap(2)) xlabel(, format(%9.0fc)) title(Inpatient Spending) legend(order(1 "Private" 2 "Public")) name(kden_inpat, replace)

* Density of hospital days
twoway (kdensity days_hosp0  , range(-2.4 2.5)) (kdensity days_hosp1 , range(-2.5 2.5) lpattern(dash)), ytitle(Density) ylabel(, angle(horizontal) format(%9.1fc)) xtitle(Deviation from Sample Mean) xtitle() xscale(titlegap(2)) xlabel(, format(%9.2fc)) title(Hospital Days) legend(order(1 "Private" 2 "Public")) name(kden_days, replace)

* Density of outpatient Spending
twoway (kdensity outpat_exp0 , range(-4 4)) (kdensity outpat_exp1  , range(-4 4) lpattern(dash)), ytitle(Density) ylabel(, angle(horizontal) format(%9.1fc)) xtitle(Deviation from Sample Mean) xtitle() xscale(titlegap(2)) xlabel(, format(%9.0fc)) title(Outpatient Spending) legend(order(1 "Private" 2 "Public")) name(kden_outpat, replace)

* Density of outpatient visits
twoway (kdensity outpat_vis0 , range(-10 10)) (kdensity outpat_vis1, range(-10 10) lpattern(dash)), ytitle(Density) ylabel(, angle(horizontal) format(%9.1fc)) xtitle(Deviation from Sample Mean) xtitle() xscale(titlegap(2)) xlabel(, format(%9.2fc)) title(Outpatient Visits) legend(order(1 "Private" 2 "Public")) name(kden_vis, replace)

*Figure 4 - Density plot of hospital days and outpatient visits
graph combine kden_days kden_vis, rows(1) name(kden_ut, replace) xsize(20) ysize(13)
graph export kden_ut_samp.emf, replace

*Figure 5 - Density plot of inpatient spending and outpatient spending
graph combine kden_inpat kden_outpat, rows(1) name(kden_exp, replace) xsize(20) ysize(13)
graph export kden_ex_samp.emf, replace



** SCATTER PLOT **
twoway (scatter days_hosp0 days_hosp1, sort msymbol(circle)) (lfit days_hosp0 days_hosp1, lpattern(dash)) , ytitle(Deviation from Sample Mean - Private) ytitle() yscale(titlegap(2)) ylabel(, angle(horizontal) format(%9.0fc)) xtitle(Deviation from Sample Mean - Public) xtitle() xscale(titlegap(2)) xlabel(, format(%9.0fc)) legend(order(1 "Estimates" 2 "Linear Prediction") rows(1)) title("Hospital Days") name(region_days, replace)
graph export region_days_samp.emf, replace

